/*  Console I/O

    Copyright (c) Express Software 1998.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

#ifndef _CONIO_H
#define _CONIO_H

#define Border11f  "Ŀ "          // The middle character will be
#define Border12f  "͸ ;"          // used to fill the window space.
#define Border22f  "ͻ ͼ"
#define Border21if "Ķ ͼ"

#define Border11e "Ŀ\0"          // If it is '\0' window will not
#define Border12e "͸\0;"          // be filled and left as it is.
#define Border22e "ͻ\0ͼ"

#define Black     0x00                  // Foreground colors.
#define Blue      0x01
#define Green     0x02
#define Cyan      0x03
#define Red       0x04
#define Magenta   0x05
#define Brown     0x06
#define White     0x07
            
#define Gray      0x08
#define BrBlue    0x09
#define BrGreen   0x0A
#define BrCyan    0x0B
#define BrRed     0x0C
#define BrMagenta 0x0D
#define Yellow    0x0E
#define BrWhite   0x0F

#define BakBlack   0x00                // Background colors.
#define BakBlue    0x10
#define BakGreen   0x20
#define BakCyan    0x30
#define BakRed     0x40
#define BakMagenta 0x50
#define BakBrown   0x60
#define BakWhite   0x70
#define Blink      0x80

#define EV_KEY   1
#define EV_SHIFT 2
#define EV_MOUSE 4
#define EV_TIMER 8

#define EV_NONBLOCK 16

#define CONIO_TICKS_PER_SEC  18.2
#define CONIO_TIMER(seconds) ((seconds)*18.2)

struct event
    {
    unsigned int ev_type;

    unsigned int key;
    unsigned int scan;
    unsigned int shift;
    unsigned int shiftX;

    unsigned int x,y;
    unsigned int left;
    unsigned int right;
    unsigned int middle;

    long timer;
    };

extern unsigned char const ScreenWidth;
extern unsigned char const ScreenHeight;
extern unsigned int const MouseInstalled;

#ifdef __cplusplus
extern "C" {
#endif

void conio_init(void);
void conio_exit(void);
void show_mouse(void);
void hide_mouse(void);
void move_mouse(int x, int y);
void move_cursor(int x, int y);
void cursor_size(int top, int bottom);
void get_event(struct event *ev, int flags);
void write_char(int attr, int x, int y, int ch);
void write_string(int attr, int x, int y, char *str);
void save_window(int x, int y, int w, int h, char *buf);
void load_window(int x, int y, int w, int h, char *buf);
void clear_window(int attr, int x, int y, int w, int h);
void scroll_window(int attr, int x, int y, int w, int h, int len);
void border_window(int attr, int x, int y, int w, int h, char *border);

#ifdef __cplusplus
}
#endif

#define SK_R_SHIFT       0x01
#define SK_L_SHIFT       0x02
#define SK_SHIFT         0x03
#define SK_CTRL          0x04
#define SK_ALT           0x08
#define SK_SCROLL_LOCKED 0x10
#define SK_NUM_LOCKED    0x20
#define SK_CAPS_LOCKED   0x40
#define SK_INSERT        0x80

#define SK_L_CTRL        0x0100
#define SK_L_ALT         0x0200
#define SK_R_CTRL        0x0400
#define SK_R_ALT         0x0800
#define SK_SCROLL_LOCK   0x1000
#define SK_NUM_LOCK      0x2000
#define SK_CAPS_LOCK     0x4000
#define SK_SYS_REQ       0x8000

#endif
