/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdlib.h>
#include <DOS.h>
#include <dir.h>
#include <direct.h>
#include <string.h>
#include "GLABEL.H"


/* copies label into nl for drive given by drvnum (1=A:,2=B:,...)
   or if no label found copies the string "No Label" into nl
*/
char *getlabel (char *nl, BYTE drvnum)
{
	struct ffblk sr;
	char path[127]="x:\\*.*";

	path[0] = drvnum+'A'-1;

	strcpy (nl, "No Label");
	if (!findfirst (path, &sr, FA_LABEL))
	{
		do
		{
			if ((sr.ff_attrib & 0xDF) == FA_LABEL)
			{
				// copy over name, but leave out dot (.) if present
				strncpy (nl, sr.ff_name, 8);
				nl[8] = '\0';
				strncpy (nl+8, sr.ff_name+9, 3);
		            nl[12] = '\0';

				return nl;
			}
		} while (!findnext (&sr));
	}

	return nl;
}
