/* int24 -- READ.ME
Enclosed find int24.c. This is a source code file for Turbo-C
that allows you to write your own "critical event handler". The
critical event handler is the code in DOS which prints the message
"Disk Error, (A)bort (R)etry (F)ail"... and gets a keystroke from
the user to decide what to do. This tends to mess up people's pretty
screens so it is nice to catch it. You might even disallow aborting, if
you don't wan't to let people abort the program.

The only thing to keep in mind is that you CANNOT call any DOS routines
in the handler, because DOS is not reentrant.

This file is provided on an as-is basis. It is public domain and I make
no claims whatsoever as to what it actually does :-) Hopefully it will
prove useful to PC programmers.

Joel Spolsky
eMail:	spolsky@cs.yale.edu 	(internet)
	SPOLSKY@YALECS		(Bitnet)
	...!harvard!yale!edu	(UUCP)

Let me know if you find any bugs...

Note: There was an earlier version of this floating around that calls
the TC function bioskey(). I got rid of that because bioskey in turn
calls DOS which is not allowed (and often hangs the computer) in
interrupt handlers.
*/

/********************************************************
 int24.c

 (C) 1990 Joel Spolsky, All Rights Reserved.
 
 This code is released into the public domain by the author.
 You can do whatever you want with it. Please let me know
 if you find it useful or if you find any bugs.
 *********************************************************/

/** int24.c
 **
 ** Interrupt 24 Handler version 0.9
 **
 ** When DOS has trouble accessing a peripheral it
 ** calls Interrupt 0x24. This is usually a pointer to
 ** the code in COMMAND.COM that prints the "Abort, Retry,
 ** Ignore" message. This is a completely portable module
 ** that replaces that message with a slightly more aesthetic
 ** one.
 **
 ** To use it, just call install_24(). To restore the DOS
 ** handler, call uninstall_24(). Warning! If you ever go
 ** into graphics mode of some sort, uninstall this! It won't
 ** be able to deal with a graphics screen correctly.
 **
 ** Note: We don't let the user ignore the error, which they shouldn't
 ** be doing anyway.
 **
 ** HISTORY
 ** -------
 ** 19 Mar 90	Created JS
 ** 16 Apr 90   Fixed to eliminate call to bioskey, which was reentering DOS
 **/

#ifndef __INT24_H__
#define __INT24_H__

/** FUNCTION PROTOTYPES **/
void install_24(void);
void uninstall_24(void);
void fastprintz(int x, int y, int attr, char *s);
int getbioskey(void);

/* These two functions can be used to allow testing if
   a drive is valid, but not cause a dialog to pop up
   when its ok to fail.  When autofail is true, then
   if the handler is called and the error code is 0x0C
   (general failure), it will set failed to nonzero and
   automatically return fail to DOS.
   It is the user's responsibility to clear failed after
   testing it.  These flag may be changed at anytime
   during exectution.  Once enabled, failed will only
   be set during a DOS function that causes the handler
   to be called.
*/
extern int autofail;
extern int failed;

#endif /* __INT24_H__ */
