/* Copyright (C) 2002 kjd */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ISPRGAVL_H__
#define __ISPRGAVL_H__

#define PROGRAM_EXT ".COM;.EXE"
#define TEXT_EXT    ";.TXT;.DOC;"

/* This will search in the current directory, followed by
   each directory specified in the PATH environment variable
   for the program.  For each directory, for each extension
   specified in extlist (separated with a semicolon and no extra
   spaces), a check is made to see if the file exists (no
   check is made to ensure the file is actually executable).
   If the file exists (can be opened) then the complete path is returned,
   otherwise the search continues.  If all directories are
   searched and the program is not found then NULL is returned.
   Note: the string returned refers to a static buffer and
   is overwritten with each call.
   Note: this function may return NULL when in fact the program
   exists if there is not enough memory to copy the PATH into a
   scratch buffer.
*/
char * isProgramAvailable(const char *progname, const char *extlist);

#endif /* __ISPRGAVL_H__ */
