; LBAcache - a hard disk cache based on XMS, 386 only, 
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001

; Check out the CHS version as well (limited to 8 GB,
; uses less DOS memory, and wimps out on LBA write)...

	; parse command line and display it
	; input: pointer to "that device thing"

	; recognizes words:
	; / -> skipped
	; digit -> set size in units of ksectors*
	; BUF digit -> as digit
	; DRV letters -> enable caching only for letters
	;     (C..F, aliases are 0..3, unknown are ignored)
	; ?:\anything -> ignored (e.g. the first argument in
	;     .sys mode will be c:\path\to\lbacache.sys)
	; HELP or HLP or ? -> show help message
	; FLOP -> enable floppy caching for those of (A: B:)
	;     that have a change line (change detection)
	; STAK -> enable local stack (if the outside stack is
	;     very small, e.g. less than 200 bytes)

	; new arguments to trigger former uncache functionality:
	; SYNC -> flush (empty) the stack for 0,1,0x80..0x83
	; INFO -> show some informations and statistics
	; STOP -> remove all instances as completely as possible
	; if one of those is given, the cache will not stay TSR,
	; but only do the requested task. Stop implies info.

	; anything else -> error message

	; defaults are using the size from datahead.asm sectors
	; and to cache all drives 0x80..0x83

args	dw 0	; bits: 4 flush 2 info 1 stop , 8000 stack
		; 8 is "do nothing" (after showing help!)

parsecommandline:
	push es
	push bx
	push eax
	push si
	les bx,[es:bx+0x12]	; here comes our pointer :-)
	push bx		; Sigh! StrTTY trashes registers, I forgot...
			; BX AX SI and maybe others...
	mov si,clmsg
		call strtty	; show a message on CS:SI
	pop bx

%ifdef DBGclptr
		mov ax,es
		push word clbufend	; empty silence *offset*
		call meep		; show es
		mov ax,bx
		push word clbufend	; empty silence *offset*
		call meep		; show bx
%endif

; -------------

	mov si,clbuf
clnextchar:
	mov al,[es:bx]	; read a char
	cmp al,10	; DOSsy EOF (sys) ?
	jz endcmdline
	cmp al,13	; DOSsy EOF (com/exe) ?
	jz endcmdline
	cmp al,0	; other EOF ?
	jz endcmdline
	cmp si,clbufend	; byte reserved for EOF ?
	jz endcmdline	; BAD LUCK for this char and the rest!

	cmp al,'a'	; upcase while copying
	jb clnoupcase
	cmp al,'z'
	ja clnoupcase
clupcase:
	sub al,32	; 'a'-'A'
clnoupcase:
	cmp al,9
	jnz clnomod	; <- ugh.. jNz of course!
	mov al,' '	; convert tab to space
clnomod:

	cmp al,' '	; compress N spaces to one
jnz clnospc
cmp [cs:si-1],al	; previous also a space?
jnz clnospc
	dec si	; simply move new space to old one
clnospc:
	mov [cs:si],al	; store that char
	inc si
	inc bx
	jmp short clnextchar

endcmdline:
	cmp si,clbuf	; check for trailing space only if
			; there is any command line!
	jbe clnotrail
	cmp byte [cs:si-1],' '	; remove the max 1
	jnz clnotrail	; (compressed) trailing space
	dec si
clnotrail:
	xor ax,ax
	mov [cs:si],ax	; terminate buffer (strongly!)

; --------------

clfeedback:	; show the user the command line
	mov si,clbuf
	call strtty	; print that buffer!
	mov si,crlfmsg
		call strtty	; print CRLF

	mov si,clbuf	; start parsing

; -------------

clnextword:
	mov eax,[cs:si]	; think big...
	shr eax,8	; remove 1st char
	cmp ax,':\'	; ignore those
	jz near clignored2
	mov eax,[cs:si]	; think big again
	inc si			; parse on... (skip " " etc.)
	cmp al,0	; eof?
	jz near clparsedone

	cmp al,'/'	; "/option" is the same as "option"
	jz clnextword

	cmp al,' '	; space?
	jz clnextword	; skip over space
	cmp ah,0
	jnz clnw
	mov ah,' '	; simplify this
clnw:
	cmp ax,'? '	; "?" help request?
	jz near clhelp
	cmp ah,' '	; one-letter/digit argument?
	jz near clonedigit
	cmp eax,'HELP'	; HELP request?
	jz clhelp2
	cmp eax,'HLP '
	jz clhelp2	; HLP request?
	cmp eax,'HLP'
	jz clhelp2	; same, but with a zero rather than a space

	cmp eax,'FLOP'
	jz clflop	; FLOP floppy cache enable?

	cmp eax,'STAK'
	jz clstak	; STAK local stack activate?

	cmp eax,'INFO'
	jz clinfo	; INFO (uncache) show info and statistics?
	cmp eax,'SYNC'
	jz clsync	; SYNC (uncache) flush and sync caches?
	cmp eax,'STOP'
	jz clstop	; STOP (uncache) remove all caches? (+info)

	cmp byte [cs:si+4-1],0	; end right after our 4 chars?
	jz cltowrongarg	; at eof while only arg expecting arg possible
	cmp byte [cs:si+4-2],0	; end right after only 3 chars?
	jz cltowrongarg	; argument with an argument but at end of
			; command line -> error!
clnonfin:
	cmp eax,'BUF '	; BUF digit behaves just as digit
	jz cl2onedigit
	cmp eax,'DRV '
	jz near cldrvsel	; DRV definition list
				; which drives to cache?
cltowrongarg:
	dec si		; show full arg
	jmp clwrongarg	; reject any other arguments

; --------------

clstak:	mov ax,0x8000
	jmp short clcommon4
clsync: mov ax,4
	jmp short clcommon4
clstop: mov ax,3
	jmp short clcommon4
clinfo: mov ax,2
clcommon4:
	or [cs:args],ax	; store the flag change
	add si,4-1	; skip the keyword
	jmp clnextword

; --------------

clhelp2:
	add si,4-1	; skip the "HELP"
clhelp:
	inc word [cs:clhelpflag]	; note the help request
	or word [cs:args],8		; do not go TSR then!
clhx:	jmp clnextword

; --------------

clflop:
	add si,4-1	; skip the "FLOP"
	or word [cs:fddstat],3		; wish: cache A: -and- B:
					; findgeom may disable this later
					; in setup if no good drives found!
	mov ax,si	; save
	mov si,clfddmsg			; tell that floppies will be cached
		call strtty		; show string
	mov si,ax	; restore
	jmp clnextword_cr

; --------------

clignored2:
	add si,3	; skip "X:\"
clignored:
	mov al,[cs:si]
	cmp al,' '		; ... until space ...
	jz clhx
	cmp al,0
	jz clhx			; ... or end of line encountered
	inc si
	jmp short clignored	; parse on

; --------------

cl2onedigit:
	add si,4+1-1	; skip the "BUF "
clonedigit:		; VERY simple argument: factor 0..9 for
			; 0..9 * 1024 sectors buffer (0->0.5)
	dec si		; <- rewind to arg!
	mov bx,512	; sectors value for argument 0
	mov al,[cs:si]
	cmp al,'0'
	jb clwrongarg
	jz clonegoodarg	; argument 0 has a predefined value
	cmp al,'9'
	ja clwrongarg
	sub al,'0'	; digit to number
	mov ah,0
	shl ax,10	; factor is 1024
	mov bx,ax	; the selected cache size
clonegoodarg:
	mov [cs:sectors],bx	; write the new buffer size,
				; overriding the default size
	inc si		; skip optional unit description
	jmp clignored	; skip until space/eof

; --------------

clwrongarg:			; we did not understand this one!
	push si

%ifdef CLDBG
	mov ax,[cs:si]		; really verbose...
		push word clrejmsg	; *offset*
		call meep	; complain about syntax
		mov si,crlfmsg	; start a new line
		call strtty
%else
	mov si,clrejmsg
		call strtty	; complain about syntax
%endif

	pop si
clwalp:
	mov al,[cs:si]
	cmp al,' '		; arg sep...
	jz clwadone
	cmp al,0
	jz clwadone		; ...or line end
	push bx
	mov bx,0007
	mov ah,0x0e
		int 0x10	; show one char using TTY
	pop bx
	inc si			; next char
	jmp short clwalp	; show the illegal arg char by char
clwadone:
	mov ax,si	; save si
	mov si,crlfmsg
		call strtty	; CRLF
	mov si,ax	; restore si
	inc word [cs:clhelpflag]	; note that we have to
	jmp clnextword		; educate the user :-), parse on

; --------------

cldrvsel:			; cache only drives in (list)
	add si,4-1		; list starts here, skip "DRV "
	xor ax,ax
	mov [cs:drvselmask],ax	; assume no drives cached,
cldslp:				; add drives from user list
	mov al,[cs:si]
	inc si			; parse on
	cmp al,' '
	jz cldsdone		; list ends here
	cmp al,0
	jz cldsdone		; ...or here
	cmp al,'0'
	jb cldslp		; ignore < '0'
	cmp al,'F'
	ja cldslp		; ignore > 'F'
	cmp al,'3'
	jbe cldsdig		; 0..3 digit
	cmp al,'C'
	jb cldslp		; ignore '4' ... 'B'
	sub al,'C'
	add al,'0'
cldsdig:
	sub al,'0'		; digit to byte (0..3)
	push cx
	mov cl,al
	shl cl,2		; 4 bits per drive
	mov ax,0x1000		; 0x80...
	shr ax,cl		; select drive in mask
	pop cx
	or [cs:drvselmask],ax	; activate caching for this drive
	jmp short cldslp	; go on with list

cldsdone:
	mov ax,[cs:drvselmask]
		push word cldrvmsg
		call meep	; tell user about drive list

clnextword_cr:
	mov ax,si	; save si
	mov si,crlfmsg
		call strtty	; CRLF
	mov si,ax	; restore si
	jmp clnextword		; parse on

; --------------

clparsedone:
	mov ax,[cs:clhelpflag]
	or ax,ax		; do we have to educate the user?
	jz clpd
		push word clhelpmsg
		call meep	; show help message
	mov si,crlfmsg
		call strtty	; CRLF
	mov si,crlfmsg
		call strtty	; CRLF
clpd:
	pop si
	pop eax
	pop bx
	pop es
	ret

clmsg		db "LBAcache command line: ",0

clspc		db "X "	; a nonspace and a space for the space
			; compressor also removes leading spaces!
clbuf		db "C:\PFAD\LBACACHE.SYS 3KSECTORS DRV CF "
		db "BUF 4KSECTORS... X:\stupid-comment-trick"
clbufend	db 0,0	; dos uses an 0a char as eof, but we write 00

cldrvmsg	db "Caching drives: CDEF=",0
	; drvselmask is 0x1111 for CDEF, 0x0100 for only D, etc.!

clfddmsg	db "Floppy cache will be enabled (if drives are suitable)"
		db 13,10,0
	; see above - fddstat word - and dispatch.asm and setup.asm

clrejmsg	db "Unknown command line option: ",0

clhelpflag	dw 0	; set to display help

clhelpmsg	db 13,10
	db "Command line syntax for TSR (cache) mode:",13,10
	db "LBACACHE [[BUF] size] [DRV drivelist] [FLOP] [HELP|?]",13,10
	db "Unit of size is 1024 sectors, max value is 9.",13,10
	db "Drivelist is e.g. CD meaning drives 0x80 and 0x81,",13,10
	db "can be NULL. Defaults are 1 MByte cache, CDEF.",13,10

	db "FLOP enables the floppy read cache (with change line only).",13,10

	db "STAK allocates 500 bytes of local stack",13,10,13,10

	db "Command line syntax for non-TSR (uncache) mode:",13,10
	db "LBACACHE [INFO] [SYNC] [STOP] [HELP|?]",13,10
	db "INFO shows info on other instances, STOP removes them,",13,10
	db "SYNC flushes/syncs all instances for drives ABCDEF.",13,10

	db "Arguments like X:\YYY\ZZZ... are ignored.",13,10
	db "Number of wrong args and help requests=",0

