; functions capable of using > 32 MB drives
; for tiny and small model (buffer pointer is near)

SEGMENT _TEXT ALIGN=4 CLASS=CODE
GLOBAL _writebig, _readbig

%imacro bd_move3 3
	mov %2,%3
	mov %1,%2
%endmacro

%imacro bd_entry 0
	push bp
	mov bp,sp
	push bx
	push cx
	push dx
	push si
	push di
	push es
	push ds
%endmacro

%imacro bd_exit 0
	pop ds
	pop es
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop bp
	ret
%endmacro

%imacro bd_common 0
	bd_move3 es,bx,0	; point to int vec table
	push ds		; buffer/seg
	mov ax,[bp+10]	; buffer/offs
	push ax
	mov ax,1	; count
	push ax
	mov ax,[bp+8]	; which/hi
	push ax
	mov ax,[bp+6]	; which/lo
	push ax
	mov bx,sp
	bd_move3 ds,ax,ss	; dsbx -> structure (see above)
	mov cx,-1
	mov al,[bp+4]	; drive
%endmacro

; int writebig(Word drive, Dword which, Byte near * buffer)

_writebig:
	bd_entry
	bd_common
	call far [es:98h]	; int 26 has call far vector
	jc _big_error
_big_ok:
	add sp,10	; remove struc from stack!
	xor ax,ax
	bd_exit

; int readbig(Word drive, Dword which, Byte near * buffer)

_readbig:
	bd_entry
	bd_common
	call far [es:94h]	; int 25 has call far vector
	jnc _big_ok
_big_error:
	add sp,10	; remove struc from stack!
	mov ax,-1
	bd_exit

